#ifndef AHLGREN_TOOLS
#define AHLGREN_TOOLS


#include <sstream>
#include <iostream>
#include <iomanip>
#include <ios>
#include <string>
#include <cstdlib>
#include <vector>
#include <tuple>
#include <cctype> // isdigit
#include <algorithm>
#include <stdexcept>
#include <cstdlib> // strtol, strtod
#include <random>
#include <set> // define set intersection


namespace useful {

	// ============ Integer Functions ============ //

	// Error class thrown by destringify
	struct conversion_error : public std::domain_error {
		conversion_error() : std::domain_error("type conversion error") {}
	};

	// Error class thrown by destringify
	struct non_numeric : public conversion_error {};

	// Is string integer?
	//bool is_int(const std::string& s);
	// Is string unsigned integer?
	///bool is_uint(const std::string& s);
	// Integer Exponentiation
	unsigned pow(unsigned b, unsigned e);
	int pow(int b, unsigned e);
	template <typename T> T round(double d) { 
		return (d > 0.0) ? static_cast<T>(std::floor(d+0.5)) : static_cast<T>(std::ceil(d-0.5)); 
	}


	// ============ Random Values ============ //

	template <typename T>
	inline T uniform_continuous(T min, T max)
	{
		static_assert(std::is_floating_point<T>::value, "uniform_continuous needs floating point type\n");
		typedef std::uniform_real_distribution<T> dist_type;
		static dist_type dist;
		return dist(rng, dist_type::param_type(min,max));
		//return min + (max - min)*(rand() / static_cast<double>(RAND_MAX));
	}

	template <typename T>
	inline T uniform_discrete(T min, T max)
	{
		static_assert(std::is_integral<T>::value, "uniform_discrete needs integral type\n");
		typedef std::uniform_int_distribution<T> dist_type;
		static dist_type dist;
		return dist(rng, dist_type::param_type(min,max));
		// return min + (rand() % (max - min + 1));
	}


	// ============ Stringiy / Destringify ============ //

	// Convert anything to a string
	template <typename T>
	std::string stringify(const T& x)
	{
		std::ostringstream os;
		os << x;
		return os.str();
	}

	// Template Specializations
	//template <> std::string stringify<bool>(const bool& x);
	//// Note: no specialization for float, as hand-rolled loop gives too much error
	//template <> std::string stringify<int>(const int& x);
	//template <> std::string stringify<double>(const double& x);


	// Convert a string to anything
	template <typename T>
	T destringify(const std::string& s) 
	{
		std::istringstream is(s);
		T obj;
		is >> obj;
		char c;
		if (is.fail() || is.get(c)) throw non_numeric();
		return obj;
	}


	// Fast set intersection
	template <typename It1, typename It2, typename Fun>
	bool intersects(It1 i, It1 i_end, It2 j, It2 j_end, Fun cmp)
	{
		while (i != i_end && j != j_end) {
			const int d = cmp(*i,*j);
			if (d < 0) {
				++i;
			} else if (d > 0) {
				++j;
			} else {
				return true;
			}
		}
		return false;
	}

	template <typename It1, typename It2>
	bool intersects(It1 i, It1 i_end, It2 j, It2 j_end)
	{
		auto cmp = [](const decltype(*i)& v, const decltype(*j)& w) -> int { 
			return v == w ? 0 : (v < w ? -1 : 1);
		};
		return intersects(i,i_end,j,j_end,cmp);
	}

	template <typename T>
	bool intersects(const std::set<T>& s1, const std::set<T>& s2)
	{
		return intersects(s1.begin(),s1.end(),s2.begin(),s2.end());
	}

	// Conversion: Template Specializations

	//// Convert a boolalpha coded string to a boolean
	//template <> bool destringify<bool>(const std::string& s);
	//template <> short destringify<short>(const std::string& s);
	//template <> int destringify<int>(const std::string& s);
	//template <> long destringify<long>(const std::string& s);
	//template <> long long destringify<long long>(const std::string& s);
	//template <> unsigned short destringify<unsigned short>(const std::string& s);
	//template <> unsigned destringify<unsigned>(const std::string& s);
	//template <> unsigned long destringify<unsigned long>(const std::string& s);
	//template <> unsigned long long destringify<unsigned long long>(const std::string& s);
	//// Note: no specialization for float, as hand-rolled loop gives too much error
	//template <> double destringify<double>(const std::string& s);
	//template <> long double destringify<long double>(const std::string& s);


	//// Helpers

	//std::string integer_to_string(int n);
	//std::string double_to_string(double d);

	//template <typename T>
	//T string_to_integer(const std::string& s) 
	//{
	//	char* end;
	//	long l = std::strtol(s.c_str(), &end, 10);
	//	if (*s == '\0' || *end != '\0') throw non_numeric();
	//	return static_cast<T>(l);

	//	//// Use hand-rolled loop for efficiency
	//	//if (s.empty()) throw non_numeric();
	//	//T val = 0;
	//	//T scale = 1;
	//	//for (auto i = s.length()-1; ; --i) {
	//	//	switch (s[i]) {
	//	//	case '0': break;
	//	//	case '1': val += scale; break;
	//	//	case '2': val += 2*scale; break;
	//	//	case '3': val += 3*scale; break;
	//	//	case '4': val += 4*scale; break;
	//	//	case '5': val += 5*scale; break;
	//	//	case '6': val += 6*scale; break;
	//	//	case '7': val += 7*scale; break;
	//	//	case '8': val += 8*scale; break;
	//	//	case '9': val += 9*scale; break;
	//	//	default: {
	//	//		// first character is allowed to be -
	//	//		if (i == 0 && s.front() == '-') return -val;
	//	//		else throw non_numeric();
	//	//			 }
	//	//	}
	//	//	if (i == 0) break;
	//	//	scale *= 10;
	//	//}
	//	//return val;	
	//}


	//template <typename T>
	//T string_to_unsigned(const std::string& s) 
	//{
	//	const char* start = s.c_str();
	//	char* end;
	//	double l = std::strtoul(start, &end, 10);
	//	if (*start == '\0' || *end != '\0') throw non_numeric();
	//	return static_cast<T>(l);

	//	//// Use hand-rolled loop for efficiency
	//	//if (s.empty()) throw non_numeric();
	//	//T val = 0;
	//	//T scale = 1;
	//	//for (auto i = s.length()-1; ; --i) {
	//	//	switch (s[i]) {
	//	//	case '0': break;
	//	//	case '1': val += scale; break;
	//	//	case '2': val += 2*scale; break;
	//	//	case '3': val += 3*scale; break;
	//	//	case '4': val += 4*scale; break;
	//	//	case '5': val += 5*scale; break;
	//	//	case '6': val += 6*scale; break;
	//	//	case '7': val += 7*scale; break;
	//	//	case '8': val += 8*scale; break;
	//	//	case '9': val += 9*scale; break;
	//	//	default: throw non_numeric();
	//	//	}
	//	//	if (i == 0) break;
	//	//	scale *= 10;
	//	//}
	//	//return val;	
	//}


	//template <typename T>
	//T string_to_float(const std::string& s) 
	//{
	//	const char* start = s.c_str();
	//	char* end;
	//	double l = std::strtod(start, &end, 10);
	//	if (*start == '\0' || *end != '\0') throw non_numeric();
	//	return static_cast<T>(l);

	//	//// Use hand-rolled loop for efficiency
	//	//if (s.empty()) throw non_numeric();
	//	//double val = 0;
	//	//double scale = 1;

	//	//// find decimal (if any), note that we allow decimal at first position
	//	//std::string::size_type dec = 0;
	//	//const std::string::size_type slen = s.length();
	//	//for ( ; dec < slen; ++dec) { if (s[dec] == '.') break; }

	//	//if (dec != 0) {
	//	//	for (auto i = dec-1; ; --i) {
	//	//		switch (s[i]) {
	//	//		case '0': break;
	//	//		case '1': val += scale; break;
	//	//		case '2': val += 2*scale; break;
	//	//		case '3': val += 3*scale; break;
	//	//		case '4': val += 4*scale; break;
	//	//		case '5': val += 5*scale; break;
	//	//		case '6': val += 6*scale; break;
	//	//		case '7': val += 7*scale; break;
	//	//		case '8': val += 8*scale; break;
	//	//		case '9': val += 9*scale; break;
	//	//		default: {
	//	//			// first character is allowed to be -
	//	//			if (i == 0 && s.front() == '-') {
	//	//				val *= -1;
	//	//				break;
	//	//			} else throw non_numeric();
	//	//				 }
	//	//		}
	//	//		if (i == 0) break;
	//	//		scale *= 10;
	//	//	}
	//	//}

	//	//// Deal with decimal values
	//	//if (dec+1 < slen) {
	//	//	scale = 10;
	//	//	for (auto i = dec+1; i < slen; ++i) {
	//	//		switch (s[i]) {
	//	//		case '0': break;
	//	//		case '1': val += 1/scale; break;
	//	//		case '2': val += 2/scale; break;
	//	//		case '3': val += 3/scale; break;
	//	//		case '4': val += 4/scale; break;
	//	//		case '5': val += 5/scale; break;
	//	//		case '6': val += 6/scale; break;
	//	//		case '7': val += 7/scale; break;
	//	//		case '8': val += 8/scale; break;
	//	//		case '9': val += 9/scale; break;
	//	//		default: throw non_numeric();
	//	//		}
	//	//		if (i == 0) break;
	//	//		scale *= 10;
	//	//	}
	//	//	// return atof(s.c_str());
	//	//}

	//	//return val;
	//}


}


#endif

